<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoPendingController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/popendinglist[/{cart_id}]", [PermissionMiddleware::class], "list.po_pending")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoPendingList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/popendingview[/{cart_id}]", [PermissionMiddleware::class], "view.po_pending")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoPendingView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/popendingsearch", [PermissionMiddleware::class], "search.po_pending")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoPendingSearch");
    }
}
