<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoOverallController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pooveralllist[/{id}]", [PermissionMiddleware::class], "list.po_overall")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pooveralladd[/{id}]", [PermissionMiddleware::class], "add.po_overall")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/pooverallview[/{id}]", [PermissionMiddleware::class], "view.po_overall")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pooveralledit[/{id}]", [PermissionMiddleware::class], "edit.po_overall")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/pooverallsearch", [PermissionMiddleware::class], "search.po_overall")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/pooverallpreview", [PermissionMiddleware::class], "preview.po_overall")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallPreview", null, false);
    }
}
