<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoOverallCompiledController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pooverallcompiledlist", [PermissionMiddleware::class], "list.po_overall_compiled")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallCompiledList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pooverallcompiledadd", [PermissionMiddleware::class], "add.po_overall_compiled")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallCompiledAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/pooverallcompiledsearch", [PermissionMiddleware::class], "search.po_overall_compiled")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoOverallCompiledSearch");
    }
}
