<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoDescController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/podesclist[/{id}]", [PermissionMiddleware::class], "list.po_desc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoDescList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/podescadd[/{id}]", [PermissionMiddleware::class], "add.po_desc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoDescAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/podescaddopt", [PermissionMiddleware::class], "addopt.po_desc")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoDescAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/podescview[/{id}]", [PermissionMiddleware::class], "view.po_desc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoDescView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/podescedit[/{id}]", [PermissionMiddleware::class], "edit.po_desc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoDescEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/podescdelete[/{id}]", [PermissionMiddleware::class], "delete.po_desc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoDescDelete");
    }
}
