<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/polist[/{id}]", [PermissionMiddleware::class], "list.po")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/poadd[/{id}]", [PermissionMiddleware::class], "add.po")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/poedit[/{id}]", [PermissionMiddleware::class], "edit.po")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/posearch", [PermissionMiddleware::class], "search.po")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSearch");
    }
}
