<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoBWbcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pobwbclist[/{id}]", [PermissionMiddleware::class], "list.po_b_wbc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBWbcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pobwbcadd[/{id}]", [PermissionMiddleware::class], "add.po_b_wbc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBWbcAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pobwbcedit[/{id}]", [PermissionMiddleware::class], "edit.po_b_wbc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBWbcEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/pobwbcdelete[/{id}]", [PermissionMiddleware::class], "delete.po_b_wbc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBWbcDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/pobwbcsearch", [PermissionMiddleware::class], "search.po_b_wbc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBWbcSearch");
    }
}
