<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoBController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/poblist[/{id}]", [PermissionMiddleware::class], "list.po_b")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pobadd[/{id}]", [PermissionMiddleware::class], "add.po_b")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pobedit[/{id}]", [PermissionMiddleware::class], "edit.po_b")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/pobdelete[/{id}]", [PermissionMiddleware::class], "delete.po_b")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/pobsearch", [PermissionMiddleware::class], "search.po_b")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoBSearch");
    }
}
