<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PlSetupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/plsetuplist[/{id}]", [PermissionMiddleware::class], "list.pl_setup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PlSetupList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/plsetupedit[/{id}]", [PermissionMiddleware::class], "edit.pl_setup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PlSetupEdit");
    }
}
