<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PersonalInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/personalinfolist[/{id}]", [PermissionMiddleware::class], "list.personal_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PersonalInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/personalinfoadd[/{id}]", [PermissionMiddleware::class], "add.personal_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PersonalInfoAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/personalinfoaddopt", [PermissionMiddleware::class], "addopt.personal_info")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PersonalInfoAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/personalinfoview[/{id}]", [PermissionMiddleware::class], "view.personal_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PersonalInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/personalinfoedit[/{id}]", [PermissionMiddleware::class], "edit.personal_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PersonalInfoEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/personalinfoupdate", [PermissionMiddleware::class], "update.personal_info")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PersonalInfoUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/personalinfosearch", [PermissionMiddleware::class], "search.personal_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PersonalInfoSearch");
    }
}
