<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PayrollTimeLogController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/payrolltimeloglist[/{id}]", [PermissionMiddleware::class], "list.payroll_time_log")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollTimeLogList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/payrolltimelogadd[/{id}]", [PermissionMiddleware::class], "add.payroll_time_log")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollTimeLogAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/payrolltimelogview[/{id}]", [PermissionMiddleware::class], "view.payroll_time_log")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollTimeLogView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/payrolltimelogedit[/{id}]", [PermissionMiddleware::class], "edit.payroll_time_log")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollTimeLogEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/payrolltimelogsearch", [PermissionMiddleware::class], "search.payroll_time_log")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollTimeLogSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/payrolltimelogquery", [PermissionMiddleware::class], "query.payroll_time_log")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollTimeLogSearch", "PayrollTimeLogQuery");
    }
}
