<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PayrollMiscController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/payrollmisclist[/{id}]", [PermissionMiddleware::class], "list.payroll_misc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMiscList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/payrollmiscadd[/{id}]", [PermissionMiddleware::class], "add.payroll_misc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMiscAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/payrollmiscview[/{id}]", [PermissionMiddleware::class], "view.payroll_misc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMiscView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/payrollmiscedit[/{id}]", [PermissionMiddleware::class], "edit.payroll_misc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMiscEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/payrollmiscdelete[/{id}]", [PermissionMiddleware::class], "delete.payroll_misc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMiscDelete");
    }
}
