<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PayrollMachineDetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/payrollmachinedetailslist[/{id}]", [PermissionMiddleware::class], "list.payroll_machine_details")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMachineDetailsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/payrollmachinedetailsadd[/{id}]", [PermissionMiddleware::class], "add.payroll_machine_details")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMachineDetailsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/payrollmachinedetailsview[/{id}]", [PermissionMiddleware::class], "view.payroll_machine_details")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMachineDetailsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/payrollmachinedetailsedit[/{id}]", [PermissionMiddleware::class], "edit.payroll_machine_details")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMachineDetailsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/payrollmachinedetailsdelete[/{id}]", [PermissionMiddleware::class], "delete.payroll_machine_details")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollMachineDetailsDelete");
    }
}
