<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PayrollHolidaysController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/payrollholidayslist[/{id}]", [PermissionMiddleware::class], "list.payroll_holidays")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollHolidaysList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/payrollholidaysadd[/{id}]", [PermissionMiddleware::class], "add.payroll_holidays")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollHolidaysAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/payrollholidaysview[/{id}]", [PermissionMiddleware::class], "view.payroll_holidays")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollHolidaysView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/payrollholidaysedit[/{id}]", [PermissionMiddleware::class], "edit.payroll_holidays")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollHolidaysEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/payrollholidaysdelete[/{id}]", [PermissionMiddleware::class], "delete.payroll_holidays")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollHolidaysDelete");
    }
}
