<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PayrollFixDetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/payrollfixdetailslist[/{id}]", [PermissionMiddleware::class], "list.payroll_fix_details")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollFixDetailsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/payrollfixdetailsadd[/{id}]", [PermissionMiddleware::class], "add.payroll_fix_details")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollFixDetailsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/payrollfixdetailsview[/{id}]", [PermissionMiddleware::class], "view.payroll_fix_details")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollFixDetailsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/payrollfixdetailsedit[/{id}]", [PermissionMiddleware::class], "edit.payroll_fix_details")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollFixDetailsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/payrollfixdetailsdelete[/{id}]", [PermissionMiddleware::class], "delete.payroll_fix_details")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollFixDetailsDelete");
    }
}
