<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PayrollDetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/payrolldetailslist[/{id}]", [PermissionMiddleware::class], "list.payroll_details")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollDetailsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/payrolldetailsadd[/{id}]", [PermissionMiddleware::class], "add.payroll_details")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollDetailsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/payrolldetailsview[/{id}]", [PermissionMiddleware::class], "view.payroll_details")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollDetailsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/payrolldetailsedit[/{id}]", [PermissionMiddleware::class], "edit.payroll_details")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollDetailsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/payrolldetailsdelete[/{id}]", [PermissionMiddleware::class], "delete.payroll_details")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollDetailsDelete");
    }
}
