<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PayrollBenefitsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/payrollbenefitslist[/{id}]", [PermissionMiddleware::class], "list.payroll_benefits")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollBenefitsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/payrollbenefitsadd[/{id}]", [PermissionMiddleware::class], "add.payroll_benefits")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollBenefitsAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/payrollbenefitsaddopt", [PermissionMiddleware::class], "addopt.payroll_benefits")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollBenefitsAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/payrollbenefitsview[/{id}]", [PermissionMiddleware::class], "view.payroll_benefits")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollBenefitsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/payrollbenefitsedit[/{id}]", [PermissionMiddleware::class], "edit.payroll_benefits")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollBenefitsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/payrollbenefitsdelete[/{id}]", [PermissionMiddleware::class], "delete.payroll_benefits")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PayrollBenefitsDelete");
    }
}
