<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentResponseController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentresponselist[/{id}]", [PermissionMiddleware::class], "list.payment_response")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentResponseList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/paymentresponseadd[/{id}]", [PermissionMiddleware::class], "add.payment_response")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentResponseAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/paymentresponseview[/{id}]", [PermissionMiddleware::class], "view.payment_response")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentResponseView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/paymentresponseedit[/{id}]", [PermissionMiddleware::class], "edit.payment_response")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentResponseEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/paymentresponsedelete[/{id}]", [PermissionMiddleware::class], "delete.payment_response")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentResponseDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/paymentresponsesearch", [PermissionMiddleware::class], "search.payment_response")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentResponseSearch");
    }
}
