<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentPlanMaterialController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentplanmateriallist[/{id}]", [PermissionMiddleware::class], "list.payment_plan_material")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanMaterialList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/paymentplanmaterialadd[/{id}]", [PermissionMiddleware::class], "add.payment_plan_material")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanMaterialAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/paymentplanmaterialedit[/{id}]", [PermissionMiddleware::class], "edit.payment_plan_material")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanMaterialEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/paymentplanmaterialdelete[/{id}]", [PermissionMiddleware::class], "delete.payment_plan_material")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanMaterialDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/paymentplanmaterialsearch", [PermissionMiddleware::class], "search.payment_plan_material")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanMaterialSearch");
    }
}
