<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentPlanHsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentplanhslist[/{id}]", [PermissionMiddleware::class], "list.payment_plan_hs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanHsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/paymentplanhsadd[/{id}]", [PermissionMiddleware::class], "add.payment_plan_hs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanHsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/paymentplanhsview[/{id}]", [PermissionMiddleware::class], "view.payment_plan_hs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanHsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/paymentplanhsedit[/{id}]", [PermissionMiddleware::class], "edit.payment_plan_hs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanHsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/paymentplanhsdelete[/{id}]", [PermissionMiddleware::class], "delete.payment_plan_hs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanHsDelete");
    }
}
