<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentPlanExtraWeavingController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentplanextraweavinglist[/{id}]", [PermissionMiddleware::class], "list.payment_plan_extra_weaving")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanExtraWeavingList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/paymentplanextraweavingadd[/{id}]", [PermissionMiddleware::class], "add.payment_plan_extra_weaving")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanExtraWeavingAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/paymentplanextraweavingview[/{id}]", [PermissionMiddleware::class], "view.payment_plan_extra_weaving")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanExtraWeavingView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/paymentplanextraweavingedit[/{id}]", [PermissionMiddleware::class], "edit.payment_plan_extra_weaving")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanExtraWeavingEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/paymentplanextraweavingdelete[/{id}]", [PermissionMiddleware::class], "delete.payment_plan_extra_weaving")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanExtraWeavingDelete");
    }
}
