<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentPlanController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentplanlist[/{id}]", [PermissionMiddleware::class], "list.payment_plan")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/paymentplanadd[/{id}]", [PermissionMiddleware::class], "add.payment_plan")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/paymentplanedit[/{id}]", [PermissionMiddleware::class], "edit.payment_plan")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/paymentplanupdate", [PermissionMiddleware::class], "update.payment_plan")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/paymentplandelete[/{id}]", [PermissionMiddleware::class], "delete.payment_plan")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/paymentplansearch", [PermissionMiddleware::class], "search.payment_plan")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/paymentplanquery", [PermissionMiddleware::class], "query.payment_plan")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanSearch", "PaymentPlanQuery");
    }
}
