<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentPlanCheckController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentplanchecklist", [PermissionMiddleware::class], "list.payment_plan_check")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanCheckList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/paymentplanchecksearch", [PermissionMiddleware::class], "search.payment_plan_check")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanCheckSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/paymentplancheckquery", [PermissionMiddleware::class], "query.payment_plan_check")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPlanCheckSearch", "PaymentPlanCheckQuery");
    }
}
