<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentPeriodFController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentperiodflist[/{id}]", [PermissionMiddleware::class], "list.payment_period_f")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPeriodFList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/paymentperiodfadd[/{id}]", [PermissionMiddleware::class], "add.payment_period_f")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPeriodFAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/paymentperiodfview[/{id}]", [PermissionMiddleware::class], "view.payment_period_f")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPeriodFView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/paymentperiodfedit[/{id}]", [PermissionMiddleware::class], "edit.payment_period_f")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPeriodFEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/paymentperiodfdelete[/{id}]", [PermissionMiddleware::class], "delete.payment_period_f")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentPeriodFDelete");
    }
}
