<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentHsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymenthslist[/{id}]", [PermissionMiddleware::class], "list.payment_hs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentHsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/paymenthsadd[/{id}]", [PermissionMiddleware::class], "add.payment_hs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentHsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/paymenthsview[/{id}]", [PermissionMiddleware::class], "view.payment_hs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentHsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/paymenthsedit[/{id}]", [PermissionMiddleware::class], "edit.payment_hs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentHsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/paymenthsdelete[/{id}]", [PermissionMiddleware::class], "delete.payment_hs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentHsDelete");
    }
}
