<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentEmpGrpCheckController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentempgrpchecklist", [PermissionMiddleware::class], "list.payment_emp_grp_check")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentEmpGrpCheckList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/paymentempgrpchecksearch", [PermissionMiddleware::class], "search.payment_emp_grp_check")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentEmpGrpCheckSearch");
    }
}
