<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PaymentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/paymentlist[/{id}]", [PermissionMiddleware::class], "list.payment")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/paymentadd[/{id}]", [PermissionMiddleware::class], "add.payment")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/paymentview[/{id}]", [PermissionMiddleware::class], "view.payment")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/paymentedit[/{id}]", [PermissionMiddleware::class], "edit.payment")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/paymentdelete[/{id}]", [PermissionMiddleware::class], "delete.payment")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/paymentsearch", [PermissionMiddleware::class], "search.payment")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PaymentSearch");
    }
}
