<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PartnerQuotationPpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationpplist[/{id}]", [PermissionMiddleware::class], "list.partner_quotation_pp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationPpList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationppadd[/{id}]", [PermissionMiddleware::class], "add.partner_quotation_pp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationPpAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationppview[/{id}]", [PermissionMiddleware::class], "view.partner_quotation_pp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationPpView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationppedit[/{id}]", [PermissionMiddleware::class], "edit.partner_quotation_pp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationPpEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationppdelete[/{id}]", [PermissionMiddleware::class], "delete.partner_quotation_pp")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationPpDelete");
    }
}
