<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PartnerQuotationBuyerController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationbuyerlist[/{id}]", [PermissionMiddleware::class], "list.partner_quotation_buyer")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationBuyerList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationbuyeradd[/{id}]", [PermissionMiddleware::class], "add.partner_quotation_buyer")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationBuyerAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationbuyerview[/{id}]", [PermissionMiddleware::class], "view.partner_quotation_buyer")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationBuyerView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationbuyeredit[/{id}]", [PermissionMiddleware::class], "edit.partner_quotation_buyer")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationBuyerEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationbuyerdelete[/{id}]", [PermissionMiddleware::class], "delete.partner_quotation_buyer")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationBuyerDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/partnerquotationbuyersearch", [PermissionMiddleware::class], "search.partner_quotation_buyer")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerQuotationBuyerSearch");
    }
}
