<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PartnerProductRefController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/partnerproductreflist[/{id}]", [PermissionMiddleware::class], "list.partner_product_ref")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerProductRefList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/partnerproductrefadd[/{id}]", [PermissionMiddleware::class], "add.partner_product_ref")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerProductRefAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/partnerproductrefview[/{id}]", [PermissionMiddleware::class], "view.partner_product_ref")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerProductRefView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/partnerproductrefedit[/{id}]", [PermissionMiddleware::class], "edit.partner_product_ref")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerProductRefEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/partnerproductrefupdate", [PermissionMiddleware::class], "update.partner_product_ref")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerProductRefUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/partnerproductrefdelete[/{id}]", [PermissionMiddleware::class], "delete.partner_product_ref")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerProductRefDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/partnerproductrefsearch", [PermissionMiddleware::class], "search.partner_product_ref")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerProductRefSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/partnerproductrefpreview", [PermissionMiddleware::class], "preview.partner_product_ref")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerProductRefPreview", null, false);
    }
}
