<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PartnerBalanceController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/partnerbalancelist", [PermissionMiddleware::class], "list.partner_balance")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerBalanceList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/partnerbalancesearch", [PermissionMiddleware::class], "search.partner_balance")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerBalanceSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/partnerbalancepreview", [PermissionMiddleware::class], "preview.partner_balance")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PartnerBalancePreview", null, false);
    }
}
