<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PackingTypeTableController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/packingtypetablelist[/{id}]", [PermissionMiddleware::class], "list.packing_type_table")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeTableList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/packingtypetableview[/{id}]", [PermissionMiddleware::class], "view.packing_type_table")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeTableView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/packingtypetableedit[/{id}]", [PermissionMiddleware::class], "edit.packing_type_table")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeTableEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/packingtypetabledelete[/{id}]", [PermissionMiddleware::class], "delete.packing_type_table")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeTableDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/packingtypetablesearch", [PermissionMiddleware::class], "search.packing_type_table")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeTableSearch");
    }
}
