<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PackingTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/packingtypelist[/{id}]", [PermissionMiddleware::class], "list.packing_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/packingtypeadd[/{id}]", [PermissionMiddleware::class], "add.packing_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/packingtypeaddopt", [PermissionMiddleware::class], "addopt.packing_type")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/packingtypeview[/{id}]", [PermissionMiddleware::class], "view.packing_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/packingtypesearch", [PermissionMiddleware::class], "search.packing_type")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTypeSearch");
    }
}
