<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PackingTableFpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/packingtablefplist[/{id}]", [PermissionMiddleware::class], "list.packing_table_fp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableFpList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/packingtablefpadd[/{id}]", [PermissionMiddleware::class], "add.packing_table_fp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableFpAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/packingtablefpview[/{id}]", [PermissionMiddleware::class], "view.packing_table_fp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableFpView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/packingtablefpedit[/{id}]", [PermissionMiddleware::class], "edit.packing_table_fp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableFpEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/packingtablefpsearch", [PermissionMiddleware::class], "search.packing_table_fp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableFpSearch");
    }
}
