<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PackingTableController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/packingtablelist[/{id}]", [PermissionMiddleware::class], "list.packing_table")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/packingtableadd[/{id}]", [PermissionMiddleware::class], "add.packing_table")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/packingtableview[/{id}]", [PermissionMiddleware::class], "view.packing_table")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/packingtableedit[/{id}]", [PermissionMiddleware::class], "edit.packing_table")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/packingtablesearch", [PermissionMiddleware::class], "search.packing_table")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingTableSearch");
    }
}
