<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PackingListTmpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/packinglisttmplist[/{id}]", [PermissionMiddleware::class], "list.packing_list_tmp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListTmpList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/packinglisttmpview[/{id}]", [PermissionMiddleware::class], "view.packing_list_tmp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListTmpView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/packinglisttmpsearch", [PermissionMiddleware::class], "search.packing_list_tmp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListTmpSearch");
    }
}
