<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PackingListNoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/packinglistnolist[/{id}]", [PermissionMiddleware::class], "list.packing_list_no")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListNoList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/packinglistnoview[/{id}]", [PermissionMiddleware::class], "view.packing_list_no")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListNoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/packinglistnoedit[/{id}]", [PermissionMiddleware::class], "edit.packing_list_no")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListNoEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/packinglistnoupdate", [PermissionMiddleware::class], "update.packing_list_no")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListNoUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/packinglistnosearch", [PermissionMiddleware::class], "search.packing_list_no")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListNoSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/packinglistnoquery", [PermissionMiddleware::class], "query.packing_list_no")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackingListNoSearch", "PackingListNoQuery");
    }
}
