<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PStockController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pstocklist[/{id}]", [PermissionMiddleware::class], "list.p_stock")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PStockList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pstockadd[/{id}]", [PermissionMiddleware::class], "add.p_stock")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PStockAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pstockedit[/{id}]", [PermissionMiddleware::class], "edit.p_stock")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PStockEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/pstocksearch", [PermissionMiddleware::class], "search.p_stock")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PStockSearch");
    }
}
