<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PSizeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/psizelist[/{id}]", [PermissionMiddleware::class], "list.p_size")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PSizeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/psizeadd[/{id}]", [PermissionMiddleware::class], "add.p_size")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PSizeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/psizeview[/{id}]", [PermissionMiddleware::class], "view.p_size")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PSizeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/psizeedit[/{id}]", [PermissionMiddleware::class], "edit.p_size")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PSizeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/psizedelete[/{id}]", [PermissionMiddleware::class], "delete.p_size")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PSizeDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/psizesearch", [PermissionMiddleware::class], "search.p_size")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PSizeSearch");
    }
}
