<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PPoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ppolist[/{id}]", [PermissionMiddleware::class], "list.p_po")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PPoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ppoadd[/{id}]", [PermissionMiddleware::class], "add.p_po")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PPoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ppoview[/{id}]", [PermissionMiddleware::class], "view.p_po")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PPoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ppoedit[/{id}]", [PermissionMiddleware::class], "edit.p_po")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PPoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ppodelete[/{id}]", [PermissionMiddleware::class], "delete.p_po")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PPoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/pposearch", [PermissionMiddleware::class], "search.p_po")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PPoSearch");
    }
}
