<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PEastimateController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/peastimatelist[/{id}]", [PermissionMiddleware::class], "list.p_eastimate")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PEastimateList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/peastimateadd[/{id}]", [PermissionMiddleware::class], "add.p_eastimate")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PEastimateAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/peastimateview[/{id}]", [PermissionMiddleware::class], "view.p_eastimate")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PEastimateView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/peastimatesearch", [PermissionMiddleware::class], "search.p_eastimate")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PEastimateSearch");
    }
}
