<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PCartController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pcartlist[/{id}]", [PermissionMiddleware::class], "list.p_cart")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PCartList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pcartadd[/{id}]", [PermissionMiddleware::class], "add.p_cart")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PCartAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/pcartaddopt", [PermissionMiddleware::class], "addopt.p_cart")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PCartAddopt", null, false);
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pcartedit[/{id}]", [PermissionMiddleware::class], "edit.p_cart")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PCartEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/pcartdelete[/{id}]", [PermissionMiddleware::class], "delete.p_cart")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PCartDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/pcartsearch", [PermissionMiddleware::class], "search.p_cart")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PCartSearch");
    }
}
