<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class OmsTableController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/omstablelist[/{id}]", [PermissionMiddleware::class], "list.oms_table")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OmsTableList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/omstableview[/{id}]", [PermissionMiddleware::class], "view.oms_table")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OmsTableView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/omstableedit[/{id}]", [PermissionMiddleware::class], "edit.oms_table")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OmsTableEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/omstablesearch", [PermissionMiddleware::class], "search.oms_table")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OmsTableSearch");
    }
}
