<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class NotMonthController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/notmonthlist[/{id}]", [PermissionMiddleware::class], "list.not_month")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NotMonthList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/notmonthadd[/{id}]", [PermissionMiddleware::class], "add.not_month")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NotMonthAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/notmonthview[/{id}]", [PermissionMiddleware::class], "view.not_month")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NotMonthView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/notmonthedit[/{id}]", [PermissionMiddleware::class], "edit.not_month")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NotMonthEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/notmonthdelete[/{id}]", [PermissionMiddleware::class], "delete.not_month")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NotMonthDelete");
    }
}
