<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class NewsLetterController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/newsletterlist[/{id}]", [PermissionMiddleware::class], "list.news_letter")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NewsLetterList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/newsletteradd[/{id}]", [PermissionMiddleware::class], "add.news_letter")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NewsLetterAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/newsletterview[/{id}]", [PermissionMiddleware::class], "view.news_letter")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NewsLetterView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/newsletteredit[/{id}]", [PermissionMiddleware::class], "edit.news_letter")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NewsLetterEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/newsletterdelete[/{id}]", [PermissionMiddleware::class], "delete.news_letter")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NewsLetterDelete");
    }
}
