<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MultiplePriceController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/multiplepricelist[/{id}]", [PermissionMiddleware::class], "list.multiple_price")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MultiplePriceList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/multiplepriceadd[/{id}]", [PermissionMiddleware::class], "add.multiple_price")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MultiplePriceAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/multiplepriceview[/{id}]", [PermissionMiddleware::class], "view.multiple_price")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MultiplePriceView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/multiplepriceedit[/{id}]", [PermissionMiddleware::class], "edit.multiple_price")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MultiplePriceEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/multiplepricedelete[/{id}]", [PermissionMiddleware::class], "delete.multiple_price")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MultiplePriceDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/multiplepricesearch", [PermissionMiddleware::class], "search.multiple_price")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MultiplePriceSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/multiplepricepreview", [PermissionMiddleware::class], "preview.multiple_price")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MultiplePricePreview", null, false);
    }
}
