<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MnRecordController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/mnrecordlist[/{id}]", [PermissionMiddleware::class], "list.mn_record")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MnRecordList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/mnrecordview[/{id}]", [PermissionMiddleware::class], "view.mn_record")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MnRecordView");
    }
}
