<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MiscItemsCostController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/miscitemscostlist[/{id}]", [PermissionMiddleware::class], "list.misc_items_cost")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscItemsCostList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/miscitemscostview[/{id}]", [PermissionMiddleware::class], "view.misc_items_cost")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscItemsCostView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/miscitemscostedit[/{id}]", [PermissionMiddleware::class], "edit.misc_items_cost")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscItemsCostEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/miscitemscostsearch", [PermissionMiddleware::class], "search.misc_items_cost")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscItemsCostSearch");
    }
}
