<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MiscItemsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/miscitemslist[/{id}]", [PermissionMiddleware::class], "list.misc_items")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscItemsList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/miscitemsview[/{id}]", [PermissionMiddleware::class], "view.misc_items")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscItemsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/miscitemsedit[/{id}]", [PermissionMiddleware::class], "edit.misc_items")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscItemsEdit");
    }
}
