<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MiscController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/misclist[/{id}]", [PermissionMiddleware::class], "list.misc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/miscadd[/{id}]", [PermissionMiddleware::class], "add.misc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/miscaddopt", [PermissionMiddleware::class], "addopt.misc")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/miscview[/{id}]", [PermissionMiddleware::class], "view.misc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/miscedit[/{id}]", [PermissionMiddleware::class], "edit.misc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/miscdelete[/{id}]", [PermissionMiddleware::class], "delete.misc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MiscDelete");
    }
}
