<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MinimumInventoryLevelController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/minimuminventorylevellist[/{id}]", [PermissionMiddleware::class], "list.minimum_inventory_level")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MinimumInventoryLevelList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/minimuminventoryleveladd[/{id}]", [PermissionMiddleware::class], "add.minimum_inventory_level")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MinimumInventoryLevelAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/minimuminventorylevelview[/{id}]", [PermissionMiddleware::class], "view.minimum_inventory_level")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MinimumInventoryLevelView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/minimuminventoryleveledit[/{id}]", [PermissionMiddleware::class], "edit.minimum_inventory_level")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MinimumInventoryLevelEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/minimuminventoryleveldelete[/{id}]", [PermissionMiddleware::class], "delete.minimum_inventory_level")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MinimumInventoryLevelDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/minimuminventorylevelsearch", [PermissionMiddleware::class], "search.minimum_inventory_level")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MinimumInventoryLevelSearch");
    }
}
